 ; Ŀ
 ;   Nautilus - reduce ex-xref layers and linetypes to a minimum.          
 ;   Copyright 1996, 1997, 1998, 2007 by Rocket Software Ltd.              
 ;   You can floss your teeth with a rubber band.  It doesn't taste all    
 ;   that good, though.                                                    
 ; 

 ; Ŀ
 ;   Blonde - rename ex-xref blocks if no conflicting name is in use.      
 ; 
 (DEFUN BLONDE (/ rew fn layy namm gnunam laylis num sub ss ssnum enam entt)
  (setq rew t)
 ; Ŀ
 ;   While there are blocks in the table...                                
 ; 
  (while (setq nxblok (tblnext "block" rew))
         (setq rew ())
 ; Ŀ
 ;   Get the old and new block names.                                      
 ; 
         (setq gnunam (sos (setq namm (cdr (assoc 2 nxblok)))))
 ; Ŀ
 ;   If the old block name exists and the new one doesn't then rename it.  
 ; 
         (cond ((and gnunam (null (tblsearch "block" gnunam)))
                (command "rename" "block" namm gnunam)
;                (setq fn (open lognam "a"))
;                (write-line (strcat "Linetype " namm " renamed " gnunam) fn)
;                (close fn)
                           )))
 (princ))
 ; Ŀ
 ;   Blonde end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Blostile - restyle ex-xref attributes.                     
 ; 
 (DEFUN BLOSTILE (/ rew nxstyl nustyl styll stylst ss num esav enam entt)
  (setq rew t)
 ; Ŀ
 ;   First make a list of existing ex-xref text styles.                    
 ; 
  (while (setq nxstyl (tblnext "style" rew))
         (setq rew ())
         (setq nustyl (sos (setq styll (cdr (assoc 2 nxstyl)))))
         (if (and styll nustyl)
             (setq stylst (append stylst (list (list styll nustyl))))))
 ; Ŀ
 ;   Now process all blocks containing attributes.                         
 ; 
  (if (setq ss (ssget "x" (list (cons 0 "insert") (cons 66 1))))
      (progn
           (setq num 0)
           (while (setq esav (setq enam (ssname ss num)))
                  (setq num (1+ num))
                  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                                (setq enam (entnext enam)))))))
                         (setq styll (cdr (assoc 7 entt)))
                         (if (setq nustyl (cadr (assoc styll stylst)))
                             (entmod (subst (cons 7 nustyl)
                                            (assoc 7 entt) entt))))
                  (entupd esav))))
 (princ))
 ; Ŀ
 ;   Blostile end.                                                         
 ; 

 ; Ŀ
 ;   Subroutine Bltxt - restyle ex-xref block subentity text/attributes.   
 ;                                                                         
 ;   Notes: 1. Entnext returns nil after the last entity in a block        
 ;             definition.                                                 
 ;          2. An empty block has one subentity of type Endblk.            
 ; 
 (DEFUN BLTXT (/ rew nxstyl nustyl styll stylst blok namm entt)
  (setq rew t)
 ; Ŀ
 ;   First make a list of existing ex-xref text styles.                    
 ; 
  (while (setq nxstyl (tblnext "style" rew))
         (setq rew ())
         (setq nustyl (sos (setq styll (cdr (assoc 2 nxstyl)))))
         (if (and styll nustyl)
             (setq stylst (append stylst (list (list styll nustyl))))))
 ; Ŀ
 ;   Modify the block definition in the block tables.                      
 ; 
  (setq rew t)
  (while (setq blok (tblnext "block" rew))             ; head entity from table
         (setq rew ())
         (setq namm (cdr (assoc -2 blok)))             ; first ename after head
         (while (and namm (setq entt (entget namm)))
                (setq styll (cdr (assoc 7 entt)))
                (if (setq nustyl (cadr (assoc styll stylst)))
                    (entmod (subst (cons 7 nustyl) (assoc 7 entt) entt)))
                (setq namm (entnext namm))))
 (princ))
 ; Ŀ
 ;   Bltxt end.                                                            
 ; 

 ; Ŀ
 ;   Bonze - takes one argument, a list of lists of source and             
 ;   layer names, moves attributes in block insertions from the former     
 ;   to the latter as appropriate.  Doesn't return much.                   
 ; 
 (DEFUN BONZE (laylis / ss num enam entt layy asoc8 sublay)
  (if (setq ss (ssget "X" (list (cons 0 "insert") (cons 66 1))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
                         (setq layy (cdr (setq asoc8 (assoc 8 entt))))
                         (if (setq sublay (assoc layy laylis))
                             (entmod (subst (cons 8 (cadr sublay))
                                                             asoc8 entt)))))))
 (princ))
 ; Ŀ
 ;   Bonze end.                                                            
 ; 

 ; Ŀ
 ;   Bottle - write a boxed file header.                                   
 ;   Takes no prisoners, returns nothing.                                  
 ;   Correction - takes one argument, a filename.                          
 ; 
 (DEFUN BOTTLE (lognam / aa bb cc dd ee lognam fn)
  (setq aa "")
  (setq bb (strcat " " aa aa ""))
  (setq cc (strcat " " aa aa ""))
  (setq dd (strcat "   Xref layer and linetype reassignment log for "
                   (nopath) ".dwg"))
  (while (< (strlen dd) 76) (setq dd (strcat dd " ")))
  (setq dd (strcat dd ""))

  (setq ee (strcat "   This file was created by "
                   "Rocket Software's Nautilus.lsp                 "))
  (setq fn (open lognam "w"))
  (write-line bb fn)
  (write-line dd fn)
  (write-line ee fn)
  (write-line cc fn)
  (close fn))
 ; Ŀ
 ;   Bottle end.                                                           
 ; 

 ; Ŀ
 ;   Conger - takes one argument, a list of lists of source and            
 ;   destination linetype names, moves attributes in block insertions      
 ;   from the former to the latter as appropriate.  Doesn't return much.   
 ; 
 (DEFUN CONGER (ltlis / ss num enam entt ltyp asoc6 sublt)
  (if (setq ss (ssget "X" (list (cons 0 "insert") (cons 66 1))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                                (setq enam (entnext enam)))))))
                         (setq ltyp (cdr (setq asoc6 (assoc 6 entt))))
                         (if (and ltyp (setq sublt (assoc ltyp ltlis)))
                             (entmod (subst (cons 6 (cadr sublt))
                                                             asoc6 entt)))))))
 (princ))
 ; Ŀ
 ;   Conger end.                                                           
 ; 

 ; Ŀ
 ;   Dolphin - change all block and dimension subentities in one linetype  
 ;   to another.  Takes one argument, a list of lists, each sublist        
 ;   containing a source and a destination linetype name.                  
 ;   Doesn't return a whole lot.                                           
 ; 
 (DEFUN DOLPHIN (ltlst / rew blok namm entt ltyp asoc6 sublt)
 ;(write-line "Dolphin")
  (setq rew t)
  (while (setq blok (tblnext "block" rew))      ; head entity from table
         (setq rew ())
         (setq namm (cdr (assoc -2 blok)))      ; first ename after head
 ;       (print namm)
         (while namm
               (setq entt (entget namm))        ; the whole thing
               (setq ltyp (cdr (setq asoc6 (assoc 6 entt))))
               (if (setq sublt (assoc ltyp ltlst))
                   (entmod (subst (cons 6 (cadr sublt)) asoc6 entt)))
               (setq namm (entnext namm))))     ; next subentity ename
 (princ))
 ; Ŀ
 ;   Dolphin end (presumably the tail).                                    
 ; 

 ; Ŀ
 ;   Kraken - move all block and dimension subentities on one layer to     
 ;   another.  Takes one argument, a list of lists, each sublist           
 ;   containing a source and a destination layer name.                     
 ;   Doesn't return a whole lot.                                           
 ; 
 (DEFUN KRAKEN (laylst / rew blok namm entt layy asoc8 sublay)
  (setq rew t)
  (while (setq blok (tblnext "block" rew))      ; head entity from table
         (setq rew ())
         (setq namm (cdr (assoc -2 blok)))      ; first ename after head
         (while namm
               (setq entt (entget namm))        ; the whole thing
               (setq layy (cdr (setq asoc8 (assoc 8 entt))))
               (if (setq sublay (assoc layy laylst))
                   (entmod (subst (cons 8 (cadr sublay)) asoc8 entt)))
               (setq namm (entnext namm))))     ; next subentity ename
 (princ))
 ; Ŀ
 ;   Kraken end.                                                           
 ; 

 ; Ŀ
 ;   Medusa: move entities to new layers.                                  
 ;   Argument: Laylis, ((old_layer_name  new_layer_name) ...)              
 ;   Calls nothing, returns nothing.                                       
 ; 
 (defun medusa (laylis / num sub oldlay gnulay enam ssnum entt lacol1 lacol2
                                                                      entcol)
  (setq num 0)
  (while (setq sub (nth num laylis))
         (setq num (1+ num))
         (setq oldlay (car sub))
         (setq gnulay (cadr sub))
         (if (setq ss (ssget "X" (list (cons 8 oldlay))))
             (progn
                  (setq ssnum 0)
                  (while (setq enam (ssname ss ssnum))
                         (setq ssnum (1+ ssnum))
                         (setq entt (entget enam))
 ; Ŀ
 ;   If the layer an entity is on has a different colour from that of the  
 ;   new layer and the entity is coloured bylayer then explicitly colour   
 ;   it to the colour of the original layer.                               
 ; 
                         (setq lacol1 (cdr (assoc 62
                                            (tblsearch "layer" oldlay))))
                         (setq lacol2 (cdr (assoc 62
                                            (tblsearch "layer" gnulay))))
                         (setq entcol (cdr (assoc 62 entt)))
                         (if (and (/= lacol1 lacol2) entcol)
                             (command "change" enam "" "p" "color" lacol1 ""))
 ; Ŀ
 ;   Relayer the entity.                                                   
 ; 
                         (entmod (subst (cons 8 gnulay)
                                        (assoc 8 entt) entt))))))
 (princ))
 ; Ŀ
 ;   Subroutine Medusa end.                                                
 ; 

 ; Ŀ
 ;   Mermaid - print a log file of Xref layer reassignments.               
 ; 
 (DEFUN MERMAID (lognam laylis / fn num sub old new oldlay oldcol oldlt
                                                           newlay newcol newlt)
  (setq fn (open lognam "a"))
  (setq num 0)
  (while (setq sub (nth num laylis))
         (setq num (1+ num))
         (setq old (car sub))
         (setq new (cadr sub))
         (write-line (strcat "Layer " old " moved to " new) fn)
         (setq oldlay (tblsearch "layer" old))
         (setq oldcol (cdr (assoc 62 oldlay)))
         (setq oldlt (cdr (assoc 6 oldlay)))
         (setq newlay (tblsearch "layer" new))
         (setq newcol (cdr (assoc 62 newlay)))
         (setq newlt (cdr (assoc 6 newlay)))
         (if (/= oldcol newcol)
             (write-line (strcat "      Colour mismatch: "
                                 (itoa oldcol) " to " (itoa newcol)) fn))
         (if (and (/= oldlt newlt)
                  (/= (sos oldlt) newlt))
             (write-line (strcat "      Linetype mismatch: "
                                 oldlt " to " newlt) fn)))
  (close fn))
 ; Ŀ
 ;   Mermaid end.                                                          
 ; 

 ; Ŀ
 ;   Nopath - returns the drawing name without the path.                   
 ; 
 (DEFUN NOPATH ( / tt pos ff)
 ; Ŀ
 ;   Get drawing name with path and set pointer Pos to end of string.      
 ; 
  (setq pos (strlen (setq tt (getvar "dwgname"))))  ; start at end of string
 ; Ŀ
 ;   Remove path.                                                          
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq tt (substr tt (1+ pos)))   ; then set tt to all after
                   (setq pos 1)))                   ;  and set pos to first
         (setq pos (1- pos)))                       ; set pos to previous
 ; Ŀ
 ;   Make sure there is no trailing .dwg.                                  
 ; 
  (if (= (strcase (substr tt (- (strlen tt) 3))) ".DWG")
      (setq tt (substr tt 1 (- (strlen tt) 4))))
  tt)
 ; Ŀ
 ;   Nopath end.                                                           
 ; 

 ; Ŀ
 ;   Sausage - rename ex-xref linetypes.                                   
 ; 
 (DEFUN SAUSAGE (/ rew lognam fn layy namm gnunam laylis num sub ss ssnum
                                                                   enam entt)
  (setq lognam (strcat (nopath) ".llg"))
  (setq rew t)
 ; Ŀ
 ;   While there are linetypes in the table...                             
 ; 
  (while (setq ltyp (tblnext "ltype" rew))
         (setq rew ())
 ; Ŀ
 ;   Get the old and new linetype names.                                   
 ; 
         (setq gnult (sos (setq namm (cdr (assoc 2 ltyp)))))
 ; Ŀ
 ;   If the old linetype name exists and the new one doesn't then          
 ;   rename the linetype.                                                  
 ; 
         (cond ((and gnult (null (tblsearch "ltype" gnult)))
                (command "rename" "ltype" namm gnult)
                (setq fn (open lognam "a"))
                (write-line (strcat "Linetype " namm " renamed " gnult) fn)
                (close fn))
 ; Ŀ
 ;   If we fell through the first condition but the new name exists then   
 ;   the new name must exist, so add both names to the list to be dealt    
 ;   with later.                                                           
 ; 
               (gnult (setq ltlis (append ltlis (list (list namm gnult)))))))
 ; Ŀ
 ;   If any leftover Xref linetypes were found and Ltlis exists.           
 ; 
 ;(write-line "Sausage/Ltlis")
  (if ltlis
      (progn
 ; Ŀ
 ;   Change entities in xref linetypes to the correct linetypes.           
 ; 
           (setq num 0)
           (while (setq sub (nth num ltlis))
                  (setq num (1+ num))
                  (if (setq ss (ssget "X" (list (cons 6 (car sub)))))
                      (progn
                           (setq ssnum 0)
                           (while (setq enam (ssname ss ssnum))
                                  (setq ssnum (1+ ssnum))
                                  (setq entt (entget enam))
                                  (entmod (subst (cons 6 (cadr sub))
                                                 (assoc 6 entt) entt))))))
 ; Ŀ
 ;   Change each layer linetype to the correct one.                        
 ; 
           (setq rew t)
 ; Ŀ
 ;   While there are layers in the table...                                
 ; 
           (while (setq layy (tblnext "layer" rew))
                  (setq rew ())
                  (if (setq gnult (cadr (assoc (cdr (assoc 6 layy)) ltlis)))
                      (command "layer" "lt" gnult (cdr (assoc 2 layy)) "")))
 ; Ŀ
 ;   Change block subentities to the correct linetypes.                    
 ; 
 ;         (write-line "Sausage/Dolphin")
           (dolphin ltlis)
 ; Ŀ
 ;   Change attributes in inserted blocks to the appropriate linetypes.    
 ; 
 ;         (write-line "Sausage/Conger")
           (conger ltlis)
 ; Ŀ
 ;   Write the second part of the log file.                                
 ; 
 ;         (write-line "Sausage/Serpent")
           (serpent lognam ltlis)))
 (princ))
 ; Ŀ
 ;   Sausage end.                                                          
 ; 

 ; Ŀ
 ;   Serpent - print a log file of Xref linetype reassignments.            
 ; 
 (DEFUN SERPENT (lognam ltls / fn num sub old new)
  (setq fn (open lognam "a"))
  (setq num 0)
  (while (setq sub (nth num ltlis))
         (setq num (1+ num))
         (setq old (car sub))
         (setq new (cadr sub))
         (write-line (strcat "Linetype " old " changed to " new) fn))
  (close fn))
 ; Ŀ
 ;   Serpent end.                                                          
 ; 

 ; Ŀ
 ;   SOS - return a string split at the substring $n$ (n = any sequence    
 ;   of numerals.)  If the sequence isn't found, returns ().               
 ; 
 (DEFUN SOS (magnus / pos1 pos2 stop found$ cha)
  (setq pos1 1)               ; position of first $
  (setq pos2 1)               ; current position $
  (setq stop ())              ; stop flag
  (setq found$ ())            ; first $ located flag
 ; Ŀ
 ;   While the stop flag isn't set and there is a character at             
 ;   the current position.                                                 
 ; 
  (while (and (null stop)
              (setq cha (substr magnus pos2 1)))
 ; Ŀ
 ;   Cond: if haven't found the first $ yet, do so.                        
 ; 
         (cond ((null found$)
                (while (and (setq cha (substr magnus pos1 1))
                            (/= cha "")
                            (/= cha "$"))
                       (setq pos1 (1+ pos1)))
                (if (= cha "$")
                    (progn
                         (setq found$ T)
                         (setq pos2 (1+ pos1)))
                    (setq stop T)))
 ; Ŀ
 ;   Cond: if have found a second $ then stop.                             
 ; 
               ((and (= cha "$")
                     (> pos2 (1+ pos1)))
                (setq stop "ok"))
 ; Ŀ
 ;   Cond: second $ but without intervening space, so count as first $.    
 ; 
               ((= cha "$")
                (setq pos1 pos2)
                (setq pos2 (1+ pos2)))
 ; Ŀ
 ;   Cond: an integer.  Continue.                                          
 ; 
               ((= (type (read cha)) 'INT)
                (setq pos2 (1+ pos2)))
 ; Ŀ
 ;   Cond: neither an $ nor an integer.  The last $ must not have been     
 ;   the marker, so set Found$ to nil and start looking again.             
 ; 
               (T
                  (setq pos2 (1+ pos2))
                  (setq pos1 pos2)
                  (setq found$ ()))))
 ; Ŀ
 ;   Cond and While end.                                                   
 ;   If the $n$ sequence was found, return everything after it, else ().   
 ; 
  (if (= stop "ok")
      (substr magnus (1+ pos2))))
 ; Ŀ
 ;   Sos end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Textile - restyle ex-xref text.                            
 ; 
 (DEFUN TEXTILE (/ rew nxstyl nustyl styll num ss enam entt)
  (setq rew t)
 ; Ŀ
 ;   While there are styles in the table...                                
 ; 
  (while (setq nxstyl (tblnext "style" rew))
         (setq rew ())
 ; Ŀ
 ;   Get the old and new style names.                                      
 ; 
         (setq nustyl (sos (setq styll (cdr (assoc 2 nxstyl)))))
 ; Ŀ
 ;   Find and restyle text in style styll.                                 
 ; 
         (if (and styll nustyl (setq ss (ssget "x" (list (cons 7 styll)))))
             (progn
                  (setq num 0)
                  (while (setq enam (ssname ss num))
                         (setq num (1+ num))
                         (setq entt (entget enam))
                         (entmod (subst (cons 7 nustyl)
                                 (assoc 7 entt) entt))))))
 (princ))
 ; Ŀ
 ;   Textile end.                                                          
 ; 

 ; Ŀ
 ;   Nautilus.                                                             
 ; 
 (DEFUN C:NAUTILUS (/ rew lognam fn layy namm gnunam laylis num sub ss ssnum
                                                                   enam entt)
  (setvar "cmdecho" 0)
  (setq lognam (strcat (nopath) ".llg"))
 ; Ŀ
 ;   Write the log file header.                                            
 ;   Note that the text style and block renamers near the end do not       
 ;   add to the log file.  Maybe.                                          
 ; 
  (bottle lognam)
; (write-line "Sausage")
  (sausage)                  ; rename/reassign linetypes
  (setq rew t)
 ; Ŀ
 ;   While there are layers in the tables.                                 
 ; 
  (while (setq layy (tblnext "layer" rew))
         (setq rew ())
         (setq namm (cdr (assoc 2 layy)))
;        (write-line "Sos")
 ; Ŀ
 ;   See if the layer in question is an ex-xref layer.                     
 ; 
         (setq gnunam (sos namm))
 ; Ŀ
 ;   If the corresponding layer without the xref drawing name already      
 ;   exists, save the existing and base layer names to laylis.             
 ; 
         (cond ((and gnunam (tblsearch "layer" gnunam))
                (setq laylis (append laylis (list (list namm gnunam)))))
 ; Ŀ
 ;   If a base name was found in the existing name but there is no         
 ;   existing layer by that name, rename the layer to the base name.       
 ; 
               (gnunam
                (setq fn (open lognam "a"))
                (write-line (strcat "Layer " namm " renamed " gnunam) fn)
                (close fn)
                (command "rename" "layer" namm gnunam))))
 ; Ŀ
 ;   If any base names were found for which layers already existed then    
 ;   laylis will exist and entites will have to be individually moved to   
 ;   the base layers.                                                      
 ; 
  (if laylis
      (progn
           (write-line "Medusa")
           (medusa laylis)
 ; Ŀ
 ;   Move block subentities to the correct layers.                         
 ; 
 ;         (write-line "Kraken")
           (kraken laylis)
 ; Ŀ
 ;   Move attributes in inserted blocks to the appropriate layers.         
 ; 
 ;         (write-line "Bonze")
           (bonze laylis)
 ; Ŀ
 ;   Write the third part of the log file.                                 
 ; 
 ;         (write-line "Mermaid")
           (mermaid lognam laylis)))
 ; Ŀ
 ;   Rename ex-xref blocks if no conflicting name is in use.               
 ; 
  (blonde)
 ; Ŀ
 ;   Change text in ex-xref styles to equivalent normal styles.            
 ; 
  (textile)
  (blostile)
  (bltxt)
 (princ))